﻿#pragma once

#include  "Main.hpp"

class CPasswordDialog :
  public CDialogImpl<CPasswordDialog>,
  public CWinDataExchange<CPasswordDialog>
{
private:
  CComBSTR archivePath;
  CComBSTR password;
  CEdit    passwordEdit;
  szchar   prevChar;
  bool     show;

public:
  enum { IDD = IDD_PASSWORD };

  CPasswordDialog(const szstring &archivePath, const szstring &password) :
    archivePath(archivePath.c_str()),
    password(password.c_str()),
    passwordEdit(),
    prevChar(0),
    show(false)
  {
  }

  szstring GetPassword()
  {
    return szstring(password.m_str);
  }

  BEGIN_MSG_MAP(CPasswordDialog)
    MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
    COMMAND_ID_HANDLER(IDOK, OnOK)
    COMMAND_ID_HANDLER(IDCANCEL, OnCancel)
    COMMAND_ID_HANDLER(IDC_SHOW_CHECK, OnShowCheck)
  END_MSG_MAP()

  BEGIN_DDX_MAP(CPasswordDialog)
    DDX_TEXT          (IDC_ARCHIVE_TEXT,  archivePath)
    DDX_TEXT          (IDC_PASSWORD_EDIT, password)
    DDX_CHECK         (IDC_SHOW_CHECK,    show)
    DDX_CONTROL_HANDLE(IDC_PASSWORD_EDIT, passwordEdit)
  END_DDX_MAP()

  LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL &bHandled)
  {
    CenterWindow();

    HICON hIcon = (HICON)::LoadImage(theModule.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
      IMAGE_ICON, ::GetSystemMetrics(SM_CXICON), ::GetSystemMetrics(SM_CYICON), LR_DEFAULTCOLOR);
    SetIcon(hIcon, TRUE);
    HICON hIconSmall = (HICON)::LoadImage(theModule.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
      IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), LR_DEFAULTCOLOR);
    SetIcon(hIconSmall, FALSE);

    DoDataExchange(FALSE);

    SetWindowText(SZT("Password"));
    SetDlgItemText(IDC_ARCHIVE_CAPTION, SZT("Archive:"));
    SetDlgItemText(IDC_PASSWORD_CAPTION, SZT("Password:"));

    SetDlgItemText(IDCANCEL, SZT("Cancel"));
    SetDlgItemText(IDC_SKIP_BUTTON, SZT("Skip"));
    SetDlgItemText(IDC_SKIP_ALL_BUTTON, SZT("Skip all"));
    SetDlgItemText(IDC_SHOW_CHECK, SZT("Show"));

    return TRUE;
  }

  LRESULT OnOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL &bHandled)
  {
    DoDataExchange(TRUE);

    EndDialog(wID);
    return 0;
  }

  LRESULT OnCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL &bHandled)
  {
    EndDialog(wID);
    return 0;
  }

  LRESULT OnShowCheck(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL &bHandled)
  {
    DoDataExchange(TRUE);

    szchar currChar = passwordEdit.GetPasswordChar();
    passwordEdit.SetPasswordChar(prevChar);
    prevChar = currChar;
    passwordEdit.Invalidate();

    return 0;
  }
};
